#迷路探索（幅優先探索）
import random

# 迷路の幅と高さ。スタートは左上、ゴールは右下です。
mapw, maph = 11, 9
sx, sy = 1, 1
ex, ey = mapw - 2, maph - 2
# 迷路のデータです。
maze_map = [
    ["#","#","#","#","#","#","#","#","#","#","#"],
    ["#"," "," "," ","#"," "," "," "," "," ","#"], 
    ["#","#","#"," ","#"," ","#","#","#"," ","#"], 
    ["#"," "," "," ","#"," "," "," ","#"," ","#"], 
    ["#","#","#"," ","#"," ","#"," ","#","#","#"], 
    ["#"," "," "," "," "," ","#"," ","#"," ","#"], 
    ["#"," ","#"," ","#","#","#"," ","#"," ","#"], 
    ["#"," "," "," ","#"," "," "," "," "," ","#"], 
    ["#","#","#","#","#","#","#","#","#","#","#"]]

def espace_maze(x, y):
    # 調べる方向を用意します（下、右、上、左）。
    dx = [0, 1, 0, -1]
    dy = [1, 0, -1, 0]
    # 調べるリストに「スタート位置と歩数」を追加します。
    pos = [[x, y, 0]]
    # 調べるリストがなくなるまでくり返します。
    while len(pos) > 0:
        # 調べるリストの先頭から「位置と歩数」を取り出します。
        (x, y, steps) = pos.pop(0)
        # ゴールなら、そこまでの歩数を表示して終了します。
        if maze_map[y][x] == "G":
            print("脱出", steps,"歩")
            break
        # mapに歩数を２桁の数字で書き込みます。
        maze_map[y][x] = f"{steps:02d}"
        # 今いる位置から4方向に進めるかを調べます。
        for i in range(4):
            wx = x + dx[i]
            wy = y + dy[i]
            p = maze_map[wy][wx]
            # 進もうとする位置が、はじめて進む道かゴールなら
            if p == " " or p == "G":
                # 調べるリストに「進める位置と歩数」を追加します。
                pos.append([wx, wy, steps + 1])

# 迷路の脱出ルートを見つけます。
maze_map[ey][ex] = "G"
espace_maze(sy, sx)
maze_map[sy][sx] = "S"

# 迷路の脱出ルートを表示します。
for i in maze_map:
    line = ""
    for j in i:
        # 2桁の数字にあわせて、1文字は2文字にします。
        if len(j)==1:
            j = j*2
        line += j + " "
    print(line)
    